package org.eaglei.suggest.client;
import java.util.List;

import org.eaglei.model.EIClass;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;


public abstract class OntologyDropdownBase extends Composite implements ClickHandler,
		MouseOverHandler, MouseOutHandler {
	
    protected class ResourceTreeWidget extends Composite implements MouseOverHandler, MouseOutHandler, ClickHandler {
        
        EIClass resource;
        Label l;
        // A place to stash a flag indicating that the child
        // list is current set to Loading...
        public boolean childListLoading;
        
        public ResourceTreeWidget(EIClass resource) {
            this.resource = resource;
            l = new Label(resource.getEntity().getLabel());
            l.setStyleName("ResourceTreeItem");
            l.addMouseOverHandler(this);
            l.addMouseOutHandler(this);
            l.addClickHandler(this);
            initWidget(l);
        }

        public void onMouseOver(MouseOverEvent event) {
            l.addStyleDependentName("hovering");
            currentItemHover = this;
        }

        public void onMouseOut(MouseOutEvent event) {
            l.removeStyleDependentName("hovering");
        }

        public void onClick(ClickEvent event) {
            handleSelection(resource);
        }
        
        public EIClass getResource() {
            return resource;
        }
    }

    protected final HorizontalPanel p = new HorizontalPanel();
    protected final Image image = new Image("images/ontology.png");
    protected final PushButton button = new PushButton(new Image("images/drop_arrow.png"));

    protected PopupPanel popup;
    protected ScrollPanel scroll;
    protected Tree tree;

    // The root resource of the type tree being displayed.
    protected EIClass rootClass;
    // Flag indicating that the root list of items is currently
    // being loaded.
    protected boolean rootListLoading;
    protected SelectionListener listener;
    protected ResourceTreeWidget currentItemHover;
    
    protected abstract void populateChildList(final TreeItem item);
    protected abstract void populateChildList(final TreeItem parent, ResourceTreeWidget parentWidget, List<EIClass> subclasses);
    protected abstract void doOnClick(ClickEvent event);
    
    protected void init()
    {
    	p.setStyleName("OntologyDropdown");

        image.setStyleName("OntologyDropdown-Image");
        image.addMouseOverHandler(this);
        image.addMouseOutHandler(this);
        p.add(image);
        p.setCellWidth(image, "100%");

        button.setStyleName("OntologyDropdown-DropButton");
        button.addMouseOverHandler(this);
        button.addMouseOutHandler(this);
        // If doing a tooltip, need to ensure it gets cleared
        // when the popup is displayed.
        // button.setTitle("Taxonomy browser");
        p.add(button);

        initWidget(p);

        // Defer initialization of the popup.
        DeferredCommand.addCommand(new Command() {

            public void execute() {
                popup = new PopupPanel(true);
                // AnimationType is currently not public
                // popup.setAnimationEnabled(true);
                // popup.setAnimationType(PopupPanel.AnimationType.ROLL_DOWN);
                popup.setStyleName("OntologyDropdown-PopupPanel");
                scroll = new ScrollPanel();
                tree = new Tree();
                tree.setAnimationEnabled(true);
                // Handler that dynamically populates child lists
                tree.addOpenHandler(new OpenHandler<TreeItem>() {
                    public void onOpen(OpenEvent<TreeItem> event) {
                        ResourceTreeWidget w = (ResourceTreeWidget) event.getTarget().getWidget();
                        if (w.getResource().hasSubClass() && w.childListLoading) {
                            populateChildList(event.getTarget());
                        } else {
                            setPopupHeight();
                        }
                    } 
                });
                tree.addCloseHandler(new CloseHandler<TreeItem>() {
                    @Override
                    public void onClose(CloseEvent<TreeItem> event) {
                        setPopupHeight();
                    }
                });
                scroll.setWidget(tree);
                popup.setWidget(scroll);
                popup.addAutoHidePartner(image.getElement());
                popup.addAutoHidePartner(button.getElement());
                popup.addCloseHandler(new CloseHandler<PopupPanel>() {
                    public void onClose(CloseEvent<PopupPanel> event) {
                        handlePopupClose();
                    }
                });
                
                // Don't allow click until the tree is initialized
                image.addClickHandler(OntologyDropdownBase.this);
                button.addClickHandler(OntologyDropdownBase.this);
            }

        });

    }
    
    public void onClick(ClickEvent event) {
    	doOnClick(event);
    }
    
    public void addSelectionListener(SelectionListener listener) {
        this.listener = listener;
    }

    private void handleSelection(EIClass resource) {
        listener.onSelection(resource);
        popup.hide();
    }

    public void onMouseOver(MouseOverEvent event) {
        //p.addStyleDependentName("hovering");
    }

    public void onMouseOut(MouseOutEvent event) {
        //if (!popup.isShowing()) {
        //    p.removeStyleDependentName("hovering");
        //}
    }
    
    private void handlePopupClose() {
    	if (currentItemHover != null) {
    		currentItemHover.l.removeStyleDependentName("hovering");
    	}
    }

    public void setResource(EIClass resource) {
        rootClass = resource;
        if (tree != null) {
            tree.clear();
            scroll.getElement().getStyle().clearHeight();
        }
        if (rootClass.hasSubClass()) {
            if (tree != null) {
                //tree.add(ApplicationImages.LOADING); // TODO: move this somewhere accessible!
            }
            rootListLoading = true;
        } else {
            // Probably should assert...
            if (tree != null) {
                tree.addItem("No types are available");
            }
        }
    }
    
    private void setPopupHeight() {
        DeferredCommand.addCommand(new Command() {
            public void execute() {
                int h = tree.getOffsetHeight();
                int maxHeight = computeMaxHeight();
                if (h > maxHeight) {
                    scroll.setHeight(maxHeight + "px");
                } else {
                    scroll.getElement().getStyle().clearHeight();
                }
                popup.showRelativeTo(p);
            }
        });
    }
    
    private int computeMaxHeight() {
        // Calculate top position for the popup
        int top = p.getAbsoluteTop();

        // Make sure scrolling is taken into account, since
        // widget.getAbsoluteTop() takes scrolling into account.
        int windowTop = Window.getScrollTop();
        int windowBottom = Window.getScrollTop() + Window.getClientHeight();

        // Distance from the top edge of the window to the top edge of the
        // widget
        int distanceFromWindowTop = top - windowTop;

        // Distance from the bottom edge of the window to the bottom edge of
        // the widget
        int distanceToWindowBottom = windowBottom
            - (top + p.getOffsetHeight());

        // Prefer displaying below
        if (distanceToWindowBottom > 200) {
            return distanceToWindowBottom - 10;
        } else if (distanceFromWindowTop > 200) {
            return distanceFromWindowTop - 10;
        } else {
            return distanceToWindowBottom > distanceFromWindowTop ? distanceToWindowBottom - 10 : distanceFromWindowTop - 10;
        }
    }

}
