package org.eaglei.suggest.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.URIDereferencer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.lexical.EntityExtractionProvider;
import org.eaglei.lexical.EntityMatch;
import org.eaglei.lexical.EntityMatchRequest;
import org.eaglei.model.EIURI;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


/**
 * Auto-suggest servlet implementation.
 * 
 * TODO Use Spring to configure the SearchProviders
 * 
 * @author tbashor Original implementation.
 * @author rfrost Refactored out SearchProvider logic.
 */
public class SuggestionServlet extends HttpServlet {

	private static final long serialVersionUID = 1897057121321L;
	
    protected static final Log logger = LogFactory.getLog(SuggestionServlet.class);
    protected static final boolean DEBUG = logger.isDebugEnabled(); 

    /*
     * Flag that indicates whether the servlet is intialized.
     */
	//private boolean isInitialized = false;
	/*
	 * Suggestion provider.
	 */
	private EntityExtractionProvider eagleiModelSuggestionProvider; 

    /**
     * Default constructor. 
     */
    public SuggestionServlet() {
        // TODO Auto-generated constructor stub
    }
    
    @Override
    public void init() {
        WebApplicationContext ctx = 
            WebApplicationContextUtils.getWebApplicationContext(getServletContext());
        eagleiModelSuggestionProvider = 
            ctx.getBean("eagleiModelSuggestionProvider", EntityExtractionProvider.class);
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	    doPost(request, response);
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = request.getParameter("id");
        String classid = request.getParameter("classid");
        String q = request.getParameter("q");
        // Needed to bracket the query with some delimiter, otherwise trailing whitespace is lost.
        // Strip the brackets here, we don't need them for the json response.
        q = q.substring(1, q.length() - 1);
        // getParameter does the decoding for us
        //System.out.println("encoded: "+q);
        //q = URL.decode(q, "UTF-8");
        //System.out.println("decoded: "+q);
        String asyncCallback = request.getParameter("callback");
        
        // For suggest list, don't throw an error, just return nothing.
        List<EntityMatch> suggestions = null;
        EntityMatchRequest entityRequest = null;
        if (classid == null) {
            entityRequest = new EntityMatchRequest(q);
        } else {                
            String decodedClassId = URLDecoder.decode(classid, "UTF-8");
            logger.info("Getting suggestions for class id: " + decodedClassId);
            entityRequest = new EntityMatchRequest(q, EIURI.create(decodedClassId));
        }
        entityRequest.setMaxMatches(10);
        suggestions = eagleiModelSuggestionProvider.match(entityRequest);
    
        StringBuilder sb = new StringBuilder();
        sb.append(asyncCallback);
        sb.append("({");  // function wrap start
        writeJsonNameValueString(sb, "id", id);
        sb.append(',');
        /*  Commenting out return of the user query input.
         *  It is only used for debugging, and putting user input
         *  into json is a potential security risk.
        writeJsonNameValueString(sb, "q", q);
        sb.append(',');
        */
        sb.append("suggestions");
        sb.append(":[");
        if (suggestions != null && suggestions.size() > 0) {
            int i=0;
            while (true) {
                EntityMatch suggestion = suggestions.get(i++);
                sb.append("\"");
                sb.append(suggestion.getHighlight());
                sb.append("\"");
                sb.append(',');
                writeJsonValueString(sb, suggestion.getMatchLabel());
                sb.append(',');
                writeJsonValueString(sb, suggestion.getEntity().getURI().toString());
                if (i == suggestions.size()) {
                    break;
                } else {
                    sb.append(',');
                }
            }
        }
        sb.append("]");
        sb.append("})");  // function wrap end
        String output = sb.toString();

        response.setContentType("text/javascript");
        response.addHeader("Pragma", "no-cache");
        response.setStatus(200);
        
        PrintWriter out = response.getWriter();

        out.println(output);
	}
	
    private static void writeJsonNameValueString(StringBuilder sb, String name, String value) {
        sb.append(name);
        sb.append(":");
        writeJsonValueString(sb, value);
    }

    private static void writeJsonValueString(StringBuilder sb, String value) {
        sb.append("\"");
        sb.append(value);
        sb.append("\"");
    }

}
