/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;
import org.eaglei.ui.gwt.security.SessionContext;

public class SearchContext {
    public static final SearchServiceRemoteAsync searchService = (SearchServiceRemoteAsync)GWT.create(SearchServiceRemote.class);
    public static final SearchContext INSTANCE = new SearchContext();
    private boolean pending = false;
    private SearchRequest currentRequest = null;
    private ClientSearchResultSet currentResults = null;
    private ArrayList<SearchListener> listeners = new ArrayList();

    private SearchContext() {
    }

    public void addListener(SearchListener listener) {
        this.listeners.add(listener);
    }

    public boolean isPending() {
        return this.pending;
    }

    public SearchRequest getCurrentRequest() {
        return this.currentRequest;
    }

    public ClientSearchResultSet getCurrentResults() {
        return this.currentResults;
    }

    public void setCurrentRequest(SearchRequest request) {
        if (this.isNewRequest(request)) {
            this.setCurrentRequestInternal(request, false);
        }
    }

    private void setCurrentRequestInternal(SearchRequest request, boolean isPageRequest) {
        this.currentRequest = request;
        this.currentResults = null;
        for (SearchListener listener : this.listeners) {
            listener.onRequest(request, isPageRequest);
        }
    }

    private boolean isNewRequest(SearchRequest request) {
        if (this.currentRequest == null && request != null) {
            return true;
        }
        return !this.currentRequest.equals((Object)request);
    }

    public void clearSearch() {
        this.pending = false;
        this.setCurrentRequestInternal(null, false);
    }

    public void search(final SearchRequest request, boolean isPageRequest) {
        if (!this.isNewRequest(request)) {
            return;
        }
        if (request == null) {
            this.clearSearch();
        } else {
            if (SessionContext.INSTANCE.getSession() == null) {
                Window.alert((String)"Please login.");
                return;
            }
            if (this.currentRequest == null) {
                isPageRequest = false;
            }
            this.pending = true;
            this.setCurrentRequestInternal(request, isPageRequest);
            searchService.search(SessionContext.getSessionId(), request, new AsyncCallback<ClientSearchResultSet>(){

                public void onFailure(Throwable caught) {
                    if (SearchContext.this.currentRequest == null || !SearchContext.this.currentRequest.equals((Object)request)) {
                        return;
                    }
                    for (SearchListener listener : SearchContext.this.listeners) {
                        listener.onFailure(request, caught.getMessage());
                    }
                    SearchContext.this.pending = false;
                }

                public void onSuccess(ClientSearchResultSet results) {
                    if (SearchContext.this.currentRequest == null || !SearchContext.this.currentRequest.equals((Object)results.getResultSet().getRequest())) {
                        return;
                    }
                    SearchContext.this.pending = false;
                    SearchContext.this.currentResults = results;
                    for (SearchListener listener : SearchContext.this.listeners) {
                        listener.onResults(results);
                    }
                }
            });
            ApplicationContext.setHistory("results/", request.toURLParams());
        }
    }

    public static interface SearchListener {
        public void onRequest(SearchRequest var1, boolean var2);

        public void onResults(ClientSearchResultSet var1);

        public void onFailure(SearchRequest var1, String var2);
    }
}

