/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.SideBar;

public class ResourceNavigatorComponent
extends SideBar.Component {
    private ResourceNavigatorPanel p = new ResourceNavigatorPanel();

    public ResourceNavigatorComponent() {
        super("Resource");
        this.setWidget((Widget)this.p);
    }

    public void setSearchRequest(SearchRequest request) {
        this.p.setSearchRequest(request);
    }

    private static class ResourceNavigatorPanel
    extends Composite {
        private static final int MAX_TOPICS = 5;
        private static final int MARGIN_INCREMENT = 6;
        private static final String STANDARD_TEXT_INDENT = "-10px";
        private static final String ARROW_TEXT_INDENT = "-14px";
        private final VerticalPanel outer = new VerticalPanel();
        private int currentMargin;
        private SearchRequest request;
        private EIURI currentURI = null;

        ResourceNavigatorPanel() {
            this.initWidget((Widget)this.outer);
        }

        void setSearchRequest(SearchRequest request) {
            this.request = request;
            EIURI uriResultType = request.getBinding() != null ? request.getBinding().getType() : null;
            this.setResource(uriResultType);
        }

        private UIObject addLabel(EIClass c, HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
            UIObject ui = this.addLabel(c.getEntity().getLabel());
            this.setClassDefinitionTooltip(c, ui, mapNoDefClassToUIObject);
            return ui;
        }

        private UIObject addLabel(String labelString) {
            Label l = new Label(labelString);
            DOM.setStyleAttribute((Element)l.getElement(), (String)"textIndent", (String)STANDARD_TEXT_INDENT);
            DOM.setStyleAttribute((Element)l.getElement(), (String)"marginLeft", (String)(this.currentMargin + "px"));
            DOM.setStyleAttribute((Element)l.getElement(), (String)"fontWeight", (String)"bold");
            this.outer.add((Widget)l);
            return l;
        }

        private UIObject addAncestorLink(EIClass c, HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
            UIObject ui = this.addLink(c, true, false, mapNoDefClassToUIObject);
            return ui;
        }

        private UIObject addSubClassLink(EIClass c, HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
            UIObject ui = this.addLink(c, false, c.hasSubClass(), mapNoDefClassToUIObject);
            return ui;
        }

        private UIObject addLink(EIClass c, boolean displayArrow, boolean bold, HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
            Label ui = this.addLink(c.getEntity().getLabel(), c.getEntity().getURI(), displayArrow, bold);
            this.setClassDefinitionTooltip(c, (UIObject)ui, mapNoDefClassToUIObject);
            return ui;
        }

        private Label addLink(String labelString, final EIURI typeBindingURI, boolean displayArrow, boolean bold) {
            Label l;
            if (displayArrow) {
                l = new Label("< " + labelString);
                DOM.setStyleAttribute((Element)l.getElement(), (String)"textIndent", (String)ARROW_TEXT_INDENT);
            } else {
                l = new Label(labelString);
                DOM.setStyleAttribute((Element)l.getElement(), (String)"textIndent", (String)STANDARD_TEXT_INDENT);
            }
            DOM.setStyleAttribute((Element)l.getElement(), (String)"marginLeft", (String)(this.currentMargin + "px"));
            if (bold) {
                DOM.setStyleAttribute((Element)l.getElement(), (String)"fontWeight", (String)"bold");
            }
            l.setStyleName("link");
            l.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    l.addStyleDependentName("hovering");
                }
            });
            l.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    l.removeStyleDependentName("hovering");
                }
            });
            l.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SearchRequest newRequest = new SearchRequest();
                    newRequest.setInstitution(ResourceNavigatorPanel.this.request.getInstitution());
                    if (ResourceNavigatorPanel.this.request.getTerm() != null) {
                        newRequest.setTerm(new SearchRequest.Term(ResourceNavigatorPanel.this.request.getTerm()));
                    }
                    if (typeBindingURI != null) {
                        newRequest.setBinding(new SearchRequest.TypeBinding(typeBindingURI));
                    }
                    SearchContext.INSTANCE.search(ResourceNavigatorPanel.this.request, false);
                }
            });
            this.outer.add((Widget)l);
            return l;
        }

        private void setResource(EIURI uri) {
            if (this.outer.getWidgetCount() > 0) {
                if (uri != null && uri.equals((Object)this.currentURI)) {
                    return;
                }
                if (uri == null && this.currentURI == null) {
                    return;
                }
            }
            this.currentURI = uri;
            this.outer.setVisible(false);
            this.outer.clear();
            this.currentMargin = 18;
            if (uri == null) {
                this.addLabel("Any Resource");
                ClientModelManager.INSTANCE.getTopLevelClasses(new ClientModelManager.TopLevelClassesCallback(){

                    public void onSuccess(List<EIClass> result) {
                        ResourceNavigatorPanel.this.currentMargin += 6;
                        HashMap mapNoDefClassToUIObject = new HashMap();
                        for (EIClass top : result) {
                            ResourceNavigatorPanel.this.addSubClassLink(top, mapNoDefClassToUIObject);
                        }
                        ResourceNavigatorPanel.this.getClassDefinitions(mapNoDefClassToUIObject);
                        ResourceNavigatorPanel.this.outer.setVisible(true);
                    }
                });
            } else {
                this.addLink("All Resources", null, true, false);
                ClientModelManager.INSTANCE.getClass(uri, new ClientModelManager.ClassCallback(){

                    public void onSuccess(EIClass result) {
                        ResourceNavigatorPanel.this.setSuperClasses(result);
                    }
                });
            }
        }

        private void setSuperClasses(EIClass c) {
            if (!c.hasSuperClass()) {
                this.currentMargin += 6;
                HashMap<EIClass, UIObject> mapNoDefClassToUIObject = new HashMap<EIClass, UIObject>();
                this.addLabel(c, mapNoDefClassToUIObject);
                this.getClassDefinitions(mapNoDefClassToUIObject);
                this.setSubClasses(c);
            } else {
                ClientModelManager.INSTANCE.getSuperClasses(c, new ClientModelManager.SuperClassesCallback(){

                    public void onSuccess(EIClass result) {
                        ArrayList<EIClass> listAncestors = new ArrayList<EIClass>();
                        for (EIClass parent = result.getSuperClass(); parent != null; parent = parent.getSuperClass()) {
                            listAncestors.add(parent);
                        }
                        HashMap mapNoDefClassToUIObject = new HashMap();
                        for (int i = listAncestors.size() - 1; i >= 0; --i) {
                            ResourceNavigatorPanel.this.currentMargin += 6;
                            ResourceNavigatorPanel.this.addAncestorLink((EIClass)listAncestors.get(i), mapNoDefClassToUIObject);
                        }
                        ResourceNavigatorPanel.this.currentMargin += 6;
                        ResourceNavigatorPanel.this.addLabel(result, mapNoDefClassToUIObject);
                        ResourceNavigatorPanel.this.getClassDefinitions(mapNoDefClassToUIObject);
                        ResourceNavigatorPanel.this.setSubClasses(result);
                    }
                });
            }
        }

        private void setSubClasses(EIClass c) {
            if (!c.hasSubClass()) {
                this.outer.setVisible(true);
            } else {
                ClientModelManager.INSTANCE.getSubClasses(c, new ClientModelManager.SubClassCallback(){

                    public void onSuccess(EIClass result) {
                        ResourceNavigatorPanel.this.currentMargin += 6;
                        HashMap mapNoDefClassToUIObject = new HashMap();
                        for (EIClass child : result.getSubClasses()) {
                            ResourceNavigatorPanel.this.addSubClassLink(child, mapNoDefClassToUIObject);
                        }
                        ResourceNavigatorPanel.this.getClassDefinitions(mapNoDefClassToUIObject);
                        ResourceNavigatorPanel.this.outer.setVisible(true);
                    }
                });
            }
        }

        private void setClassDefinitionTooltip(EIClass clazz, UIObject ui, HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
            if (clazz.getDefinition() == null) {
                mapNoDefClassToUIObject.put(clazz, ui);
            } else {
                ui.setTitle(clazz.getDefinition());
            }
        }

        private void getClassDefinitions(final HashMap<EIClass, UIObject> mapNoDefClassToUIObject) {
            if (mapNoDefClassToUIObject.size() > 0) {
                ArrayList<EIClass> listNoDefClasses = new ArrayList<EIClass>(mapNoDefClassToUIObject.keySet());
                ClientModelManager.INSTANCE.getClassDefinitions(listNoDefClasses, new ClientModelManager.ClassDefinitionCallback(){

                    public void onSuccess(List<EIClass> result) {
                        for (EIClass clazz : result) {
                            UIObject o = (UIObject)mapNoDefClassToUIObject.get(clazz);
                            o.setTitle(clazz.getDefinition());
                        }
                    }
                });
            }
        }
    }
}

