/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.ui.gwt.search.results.ResultsListPanel;

public class ResultsTabPanel
extends Composite {
    public static int SUMMARY_DECK_INDEX;
    private static int STATUS_DECK_INDEX;
    private final VerticalPanel outer = new VerticalPanel();
    private final TabBar tabBar = new TabBar();
    private final List<Tab> listTabs = new ArrayList<Tab>();
    private final DeckPanel deck = new DeckPanel();
    private final SimplePanel statusPanel = new SimplePanel();
    private final HorizontalPanel searchingPanel = new HorizontalPanel();
    private ResultsListPanel panelSummary;
    private SearchRequest request;
    private SearchResultSet results;

    public ResultsTabPanel() {
        this.initWidget((Widget)this.outer);
        this.outer.add((Widget)this.tabBar);
        this.tabBar.setStyleName("ResultsTabBar");
        this.tabBar.setVisible(false);
        this.outer.add((Widget)this.deck);
        this.deck.setWidth("100%");
        this.deck.setHeight("100%");
        SimplePanel panelWrapper = new SimplePanel();
        this.deck.add((Widget)panelWrapper);
        Tab tab = new Tab("List"){

            @Override
            void setSelected(boolean selected) {
                super.setSelected(selected);
                if (selected) {
                    ResultsTabPanel.this.displaySummary();
                }
            }
        };
        SUMMARY_DECK_INDEX = this.tabBar.getTabCount();
        this.tabBar.addTab((Widget)tab);
        this.listTabs.add(tab);
        this.statusPanel.setStyleName("ResultsLoadingPanel");
        this.deck.add((Widget)this.statusPanel);
        STATUS_DECK_INDEX = this.tabBar.getTabCount();
        this.tabBar.addBeforeSelectionHandler((BeforeSelectionHandler)new BeforeSelectionHandler<Integer>(){

            public void onBeforeSelection(BeforeSelectionEvent<Integer> event) {
                int selectIndex = ResultsTabPanel.this.tabBar.getSelectedTab();
                if (selectIndex < 0 || selectIndex >= ResultsTabPanel.this.tabBar.getTabCount()) {
                    return;
                }
                ((Tab)((Object)ResultsTabPanel.this.listTabs.get(selectIndex))).setSelected(false);
            }
        });
        this.tabBar.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                int selectIndex = ResultsTabPanel.this.tabBar.getSelectedTab();
                if (selectIndex < 0 || selectIndex >= ResultsTabPanel.this.tabBar.getTabCount()) {
                    return;
                }
                ((Tab)((Object)ResultsTabPanel.this.listTabs.get(selectIndex))).setSelected(true);
            }
        });
        this.selectTab(SUMMARY_DECK_INDEX);
    }

    public void selectTab(int index) {
        this.tabBar.selectTab(index);
    }

    public void setLoggedOut() {
        this.statusPanel.setWidget((Widget)new Label("You must be signed in to see search results."));
        this.deck.showWidget(STATUS_DECK_INDEX);
    }

    public void setNoResults() {
        this.statusPanel.setWidget((Widget)new Label("No resources found."));
        this.deck.showWidget(STATUS_DECK_INDEX);
    }

    private void setSearching() {
        if (this.searchingPanel.getWidgetCount() == 0) {
            this.searchingPanel.add((Widget)new Label("Searching..."));
        }
        this.statusPanel.setWidget((Widget)this.searchingPanel);
        this.deck.showWidget(STATUS_DECK_INDEX);
    }

    public void setSearchRequest(SearchRequest request) {
        this.request = request;
        this.setSearching();
    }

    private void setResults(SearchResultSet results) {
        this.results = results;
        if (results == null || results.getTotalCount() == 0) {
            this.setNoResults();
        } else if (this.tabBar.getSelectedTab() == SUMMARY_DECK_INDEX) {
            this.displaySummary();
        }
    }

    private void displaySummary() {
        this.deck.showWidget(STATUS_DECK_INDEX);
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                if (ResultsTabPanel.this.panelSummary == null) {
                    ResultsTabPanel.this.panelSummary = new ResultsListPanel();
                    ((SimplePanel)ResultsTabPanel.this.deck.getWidget(SUMMARY_DECK_INDEX)).setWidget((Widget)ResultsTabPanel.this.panelSummary);
                }
                if (ResultsTabPanel.this.results != null) {
                    ResultsTabPanel.this.panelSummary.setResultSet(ResultsTabPanel.this.results);
                    ResultsTabPanel.this.deck.showWidget(SUMMARY_DECK_INDEX);
                }
            }
        });
    }

    private void displayTable() {
    }

    private void displayMap() {
    }

    private static class Tab
    extends SimplePanel {
        private boolean selected;

        Tab(String text) {
            this.setStyleName("ResultsTab");
            Label l = new Label(text);
            l.addStyleName("label");
            this.setWidget((Widget)l);
            this.addDomHandler((EventHandler)new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    if (!Tab.this.selected) {
                        Tab.this.addStyleDependentName("over");
                    }
                }
            }, MouseOverEvent.getType());
            this.addDomHandler((EventHandler)new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    if (!Tab.this.selected) {
                        Tab.this.removeStyleDependentName("over");
                    }
                }
            }, MouseOutEvent.getType());
        }

        void setSelected(boolean selected) {
            this.selected = selected;
            if (selected) {
                this.removeStyleDependentName("over");
            }
        }
    }
}

