package org.eaglei.ui.gwt.home;

import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.LoginPanel;
import org.eaglei.ui.gwt.LogoutPanel;
import org.eaglei.ui.gwt.ApplicationContext.ApplicationPage;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.SessionContext.SessionListener;
import org.eaglei.ui.gwt.suggest.DataSuggestBox;
import org.eaglei.ui.gwt.suggest.AbstractSearchBox.SearchHandler;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;

public class HomePage extends Composite implements SessionListener, ApplicationPage {

	interface MyUiBinder extends UiBinder<Widget, HomePage> {
	}

    public static boolean HAS_INSTITUTION_SELECT;

	private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

    @UiField
    DataSuggestBox termBox;
    @UiField
    ListBox institutionListBox;
    @UiField
    ListBox typeListBox;
    @UiField
    Button searchButton;
    @UiField
    LoginPanel loginPanel;
    @UiField
    LogoutPanel logoutPanel;

    // Static list of institutions
    private List<EIEntity> listInstitutionEntities = null;

    // Static list of top-level classes
    private List<EIClass> listTypeClasses = null;

	public HomePage() {
		initWidget(uiBinder.createAndBindUi(this));
		
        loginPanel.loginBox.addStyleName("homePageLoginBox");
        loginPanel.loginGrayOut.addStyleName("homePageLoginGrayOut");

        institutionListBox.setStylePrimaryName("searchboxInstitutionDropdown");

        if (HAS_INSTITUTION_SELECT) {
            initInstitutionList();
        } else {
            institutionListBox.setVisible(false);
        }
        
        SessionContext.INSTANCE.addListener(this);
        if (SessionContext.getSessionId() != null) {
            onLogIn();
        } else {
            onLogOut();
        }
        
        searchButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                SearchRequest request = getSearchRequest();
                executeSearch(request);
            }
        });

        termBox.addSearchHandler(new SearchHandler() {

            @Override
            public void performSearch(String query, String uri) {
                SearchRequest.Term term = 
                    new SearchRequest.Term(query, (uri != null ? EIURI.create(uri) : null));
                SearchRequest request = getSearchRequest(term);
                executeSearch(request);
            }
            
        }, true, true);
        
        termBox.setDefaultText();

        
        // Since resource list is currently hidden in a popup.
        // Defer population.
        DeferredCommand.addCommand(new Command() {
            
            @Override
            public void execute() {
                initResourcesList();
            }
        });
	}

    @Override
    public Widget asWidget() {
         return this;
    }

    private void initInstitutionList() {
        institutionListBox.addItem("All Institutions");
        SearchServiceRemoteAsync searchService = GWT.create(SearchServiceRemote.class);
        searchService.getInstitutions(new AsyncCallback<List<EIEntity>>() {
            
            @Override
            public void onSuccess(List<EIEntity> result) {
                listInstitutionEntities = result;
                for (EIEntity institution : result) {
                    institutionListBox.addItem(institution.getLabel());
                }
            }
            
            @Override
            public void onFailure(Throwable caught) {
            }
        });
    }

	public void setPageParams(String params) {
	    // The problem with setting the SearchContext on the Home page
	    // is that it will automatically kick off a Search All operation
	    //SearchContext.INSTANCE.setFromHistoryParams(params);
	}

	
    //------  Search bar methods ------------------------------
	
	private void initResourcesList() {
        // The first item in the resource list box will always
        // be the All Resources label (null TypeBinding)
        // The rest of the list will change dynamically based
        // on the current type binding.
        typeListBox.addItem("All Resources");
        typeListBox.setStylePrimaryName("searchboxInstitutionDropdown");
        SearchContext.searchService.getTopLevelSearchCategories(new AsyncCallback<List<EIClass>>() {
            
            @Override
            public void onSuccess(List<EIClass> result) {
                listTypeClasses = result;
                for (EIClass rclass : listTypeClasses) {
                    typeListBox.addItem(rclass.getEntity().getLabel());
                }
                typeListBox.setSelectedIndex(0);
            }

            @Override
            public void onFailure(Throwable caught) {
                
            }

        });
	    
	}
	
	private void executeSearch(SearchRequest request) {
        if (SessionContext.getSessionId() == null) {
            Window.alert("Please login");
            return;
        }
        SearchContext.INSTANCE.search(request);
	}

    private SearchRequest getSearchRequest() {
        SearchRequest.Term term = null;
        String query = termBox.getText();
        if (query != null) {
            query.trim();
            if (query.length() > 0) {
                term = new SearchRequest.Term(query);
            }
        }
        
        return (getSearchRequest(term));
    }
    
    private SearchRequest getSearchRequest(SearchRequest.Term term) {
        SearchRequest request = new SearchRequest();

        request.setTerm(term);

        if (institutionListBox != null && institutionListBox.getSelectedIndex() > 0) {
            EIURI institution = listInstitutionEntities.get(institutionListBox.getSelectedIndex() - 1).getURI();
            request.setInstitution(institution);
        }
        
        if (typeListBox != null && typeListBox.getSelectedIndex() > 0) {
            EIURI type = listTypeClasses.get(typeListBox.getSelectedIndex() - 1).getEntity().getURI();
            SearchRequest.TypeBinding binding = new SearchRequest.TypeBinding(type);
            request.setBinding(binding);
        }
        
        return request;
    }

    //------  Authentication methods ------------------------------
    
    @Override
    public void onLogIn() {
        loginPanel.setVisible(false);
        logoutPanel.setVisible(true);
    }

    @Override
    public void onLogOut() {
        loginPanel.setVisible(true);
        logoutPanel.setVisible(false);
    }


}
