package org.eaglei.ui.gwt.instance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.SearchApplicationContext;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;

public class MaterializedPropertyWidget extends Composite {

	private FlowPanel mainPanel;
	List<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
	FlowPanel materializedPanel;
	EIInstance eiInstance;
	private final InstanceChangeListener listener;
	private static final Map<String, String> typePlurals = new HashMap<String, String>() {
		private static final long serialVersionUID = 1L;

		{
			put( "Instrument", "Instruments" );
			put( "Technique", "Techniques" );
			put( "Service", "Services" );
			put( "Person", "People" );
			put( "Document", "Documents" );
			put( "Protocol", "Protocols" );
			put( "Software", "Software" );
			put( "Reagent", "Reagents" );
			put( "Human Study", "Human Studies" );
			put( "Organism or Virus", "Organisms and Viruses" );
			put( "Organization", "Organizations" );
			put( "Research Opportunity", "Research Opportunities" );
			put( "Biological Specimen", "Biological Specimens" );
			put( "Construct insert", "Construct Inserts" );
			put( "Construct Insert", "Construct Inserts" );
		}
	};
	private static final Logger log = Logger.getLogger( "MaterializedPropertyWidget" );
	private int currentIndex;

	public static final InstanceServiceRemoteAsync instanceService = GWT.create( InstanceServiceRemote.class );

	private static final int INVERSE_PROPERTIES_COUNT = 10;

	public MaterializedPropertyWidget(EIInstance eiInstance, EIEntity propertyEntity, List<EIInstanceMinimal> eiInstanceMinimalList, FlowPanel mainPanel, InstanceChangeListener listener) {
		instanceList = eiInstanceMinimalList;
		this.mainPanel = mainPanel;
		materializedPanel = new FlowPanel();
		this.listener = listener;
		this.eiInstance = eiInstance;
		initWidget( materializedPanel );
		setup();
	}

	private void setup() {
		final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap = new HashMap<EIEntity, List<EIInstanceMinimal>>();
		for (final EIInstanceMinimal eiInstanceMinimal : instanceList) {
			if ( instanceTypeMap.containsKey( eiInstanceMinimal.getDataModelRootSuperClass() ) ) {
				List<EIInstanceMinimal> instanceList = instanceTypeMap.get( eiInstanceMinimal.getDataModelRootSuperClass() );
				if ( instanceList != null ) {
					instanceList.add( eiInstanceMinimal );
				}
			} else {
				List<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
				instanceList.add( eiInstanceMinimal );
				instanceTypeMap.put( eiInstanceMinimal.getDataModelRootSuperClass(), instanceList );
			}
		}

		for (final EIEntity instanceType : instanceTypeMap.keySet()) {
			String label = typePlurals.get( instanceType.getLabel() );
			if ( label == null ) {
				log.warning( "no plural for " + instanceType.getLabel() );
				label = instanceType.getLabel();
			}
			DisclosurePanel typePanel = new DisclosurePanel( label );
			typePanel.setStyleName( "formPanelInside" );
			final FlowPanel innerPanel = new FlowPanel();
			materializedPanel.add( typePanel );

			List<EIInstanceMinimal> firstPageList = getFirstPage( instanceTypeMap.get( instanceType ) );
			displayResults( firstPageList, innerPanel );

			addNextLink( instanceTypeMap, instanceType, innerPanel );
			typePanel.setContent( innerPanel );

		}
	}

	private void addNextLink(final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap, final EIEntity instanceType, final FlowPanel innerPanel) {
		if ( getCurrentIndex() < instanceTypeMap.get( instanceType ).size() ) {
			Image next = new Image( "images/pagination-rightarrow.png" );
			next.setStyleName( "nextLink" );
			innerPanel.add( next );
			next.addClickHandler( new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					List<EIInstanceMinimal> nextPageList = getNextPage( instanceTypeMap.get( instanceType ) );
					displayResults( nextPageList, innerPanel );
					addPrevLink( instanceTypeMap, instanceType, innerPanel );
					addNextLink( instanceTypeMap, instanceType, innerPanel );
				}
			} );
		}
	}

	private void addPrevLink(final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap, final EIEntity instanceType, final FlowPanel innerPanel) {
		if ( getCurrentIndex() > INVERSE_PROPERTIES_COUNT ) {
			Image prev = new Image( "images/pagination-leftarrow.png" );
			prev.setStyleName( "prevLink" );
			innerPanel.add( prev );
			prev.addClickHandler( new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					List<EIInstanceMinimal> prevPageList = getPrevPage( instanceTypeMap.get( instanceType ) );
					displayResults( prevPageList, innerPanel );
					addPrevLink( instanceTypeMap, instanceType, innerPanel );
					addNextLink( instanceTypeMap, instanceType, innerPanel );
				}
			} );
		}
	}

	private void displayResults(final List<EIInstanceMinimal> eiInstanceMinimalList, final FlowPanel innerPanel) {
		innerPanel.clear();
		for (final EIInstanceMinimal instance : eiInstanceMinimalList) {// Window.alert( "a"+startIndex +"  "+endIndex +"  "+ eiInstanceMinimalList.get( i ).getInstanceLabel());

			ClientModelManager.INSTANCE.isModelClassURI( instance.getInstanceURI(), new AsyncCallback<Boolean>() {
				@Override
				public void onFailure(Throwable caught) {
					// log.error( "there is async error in org.eaglei.datatools.client.ui.ViewFormsPanel#draObjectProperty when calling isModelClassURI(EIURI) Async method " );
				}

				@Override
				public void onSuccess(Boolean result) {

					if ( result ) {
						Label propertyValue = new Label( instance.getInstanceLabel() );
						// propertyValueLabel.setTitle( mapTermToDefinition.get( propertyValue.getURI() ) );
						innerPanel.add( propertyValue );
					} else {
						Anchor a = new Anchor(InstanceWidgetUtils.formatText( instance.getInstanceLabel() ) );
						innerPanel.add( a );
						a.addClickHandler( new ClickHandler() {
							@Override
							public void onClick(final ClickEvent arg0) {
								log.fine( "listener changing instance to " + instance.getInstanceURI() );
								History.newItem( SearchApplicationContext.INSTANCE_PAGE_TOKEN + "uri=" + instance.getInstanceURI().toString() );
								listener.onInstanceChanged( instance.getInstanceURI() );

							}

						} );

					}
				}
			} );
		}
	}

	public int getCurrentIndex() {
		return currentIndex;
	}

	public List<EIInstanceMinimal> getFirstPage(List<EIInstanceMinimal> instanceMinimalList) {
		return iterateFrom( 0, instanceMinimalList );
	}

	public List<EIInstanceMinimal> getNextPage(List<EIInstanceMinimal> instanceMinimalList) {
		return iterateFrom( getCurrentIndex(), instanceMinimalList );
	}

	public List<EIInstanceMinimal> getPrevPage(List<EIInstanceMinimal> instanceMinimalList) {
		int newStart = getCurrentIndex() - INVERSE_PROPERTIES_COUNT; // current index is the end, so our start right now is INV_PROP_COUNT before that
		if ( getCurrentIndex() % INVERSE_PROPERTIES_COUNT != 0 ) { // if we're on the last page with an irregular number
			newStart = getCurrentIndex() - (getCurrentIndex() % INVERSE_PROPERTIES_COUNT); // then the current start is just that extra chunk
		}
		newStart = newStart - INVERSE_PROPERTIES_COUNT; //Wherever we used to start, go back a page.
		return iterateFrom( newStart, instanceMinimalList );  
	}

	private List<EIInstanceMinimal> iterateFrom(final int startIndex, List<EIInstanceMinimal> instanceList) {
		final int totalSize = instanceList.size();

		int endIndex = startIndex + INVERSE_PROPERTIES_COUNT;
		currentIndex = endIndex;
		if ( endIndex > totalSize ) {
			endIndex = totalSize;
			currentIndex = totalSize; 
		}

		return instanceList.subList( startIndex, endIndex );
	}

}
