package org.eaglei.ui.gwt.instance;

import java.util.List;

import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.ui.gwt.SearchApplicationContext;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;

public class ReferencedBySidebarComponent extends Composite {
  
    protected FlowPanel outerPanel = new FlowPanel();
    protected FlowPanel linksPanel = new FlowPanel();

    public ReferencedBySidebarComponent() {
        initWidget(outerPanel); 
        setStyleName("referencedBySidebarComponent");
        
        Label title = new Label("Related Resources");
        outerPanel.add(title);
        title.setStyleName("title");
        outerPanel.add(linksPanel);
        linksPanel.setStyleName("referencesPanel");
        
        setVisible(false);
    }
    
    @Override
    public void setWidth(String width) {
        super.setWidth(width);
    }

    public void setReferences(List<EIInstanceMinimal> listReferences) { 
        setVisible(false);
        if (listReferences == null || listReferences.size() == 0) {
            return;
        }
        linksPanel.clear();
        for (EIInstanceMinimal instance : listReferences) {
            Hyperlink instanceLink = new Hyperlink(InstanceWidgetUtils.formatText( instance.getInstanceLabel() ), 
                    SearchApplicationContext.INSTANCE_PAGE_TOKEN + "uri=" +  instance.getInstanceURI().toString());
            linksPanel.add(instanceLink);
            instanceLink.addStyleName("link");
        }
        setVisible(true);
    }
}
