/**
 * 
 */
package org.eaglei.ui.gwt.search.results;

import java.util.List;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchRequest.ResourceProvider;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ListBox;

public abstract class AbstractInstitutionPropertyFilter extends PropertyFilter {
    
    // Static list of institutions
    private List<EIEntity> listInstitutionEntities = null;
    private ListBox institutionListBox;
    private EIURI currentInstitution;

    protected AbstractInstitutionPropertyFilter() {
        this("Institution");    	
    }
    
    protected AbstractInstitutionPropertyFilter(String label) {
        super(label);
        institutionListBox = new ListBox();
        add(institutionListBox);
        institutionListBox.setStyleName("value");
        institutionListBox.addStyleName("valueListBox");
        
        institutionListBox.addItem(getDefaultItem());
        fetchInstitutionList();
        institutionListBox.addChangeHandler(new ChangeHandler() {
            
            @Override
            public void onChange(ChangeEvent event) {
                EIURI selectedInstitution;
                if (institutionListBox.getSelectedIndex() > 0) {
                    selectedInstitution = listInstitutionEntities.get(institutionListBox.getSelectedIndex() - 1).getURI();
                } else {
                    selectedInstitution = null;
                }
                // On change, execute a search
                if ((selectedInstitution == null && currentInstitution != null)
                        || !selectedInstitution.equals(currentInstitution)) {
                    currentInstitution = selectedInstitution;
                    executeSearch();
                }
            }
        });
    }
    
    protected String getDefaultItem() {
        return "All Institutions";
    }
    
    protected abstract void fetchInstitutionList();
    
    protected void initInstitutionList(List<EIEntity> result) {
        listInstitutionEntities = result;
        for (EIEntity institution : result) {
            institutionListBox.addItem(institution.getLabel());
        }
        setInstitution(currentInstitution);
    }
        
    public void setSearchRequest(SearchRequest request) {
		EIURI institution = request.getLocation() != null ? request.getLocation().getInstitution() : null;
		setInstitution(institution);
    }
    
    public void setInstitution(EIURI institution) {
        currentInstitution = institution;
        // TODO check if the institution has changed to avoid traversing the
        // list if we don't have to
        if (institution != null && listInstitutionEntities != null) {
            int i = 1;
            for (EIEntity inst : listInstitutionEntities) {
                if (inst.getURI().equals(institution)) {
                    institutionListBox.setSelectedIndex(i);
                    return;
                }
                i++;
            }
        }
        institutionListBox.setSelectedIndex(0);
    }
    
    public EIURI getSelectedInstitution() {
        return currentInstitution;
    }
    
    public void onRequestCreate(SearchRequest request) {
    	ResourceProvider provider = request.getLocation();
    	if (provider != null) {
    		provider.setInstitution(currentInstitution);
    	} else {
    		if (currentInstitution != null) {
    			provider = new ResourceProvider(null, null, currentInstitution);
    			request.setLocation(provider);
    		}
    	}
    }

    protected void executeSearch() {
        SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
        SearchRequest newRequest;
        if (previousRequest != null) {
            // TODO: somewhat inefficient way to create a clone
            newRequest = new SearchRequest(previousRequest.toURLParams());
            newRequest.setStartIndex(0);
        } else {
            newRequest = new SearchRequest();
        }
        ResourceProvider provider = new ResourceProvider(null, null, currentInstitution);
        newRequest.setLocation(provider);
        SearchContext.INSTANCE.search(newRequest);
    }
    
}