package org.eaglei.ui.gwt.search.results.renderers;

import org.eaglei.model.EIEntity;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchRequest.DataSet;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.SearchApplicationContext;
import org.eaglei.ui.gwt.search.results.grid.EagleIGridRow;
import org.eaglei.ui.gwt.search.results.grid.ResourcesGrid;
import org.eaglei.ui.gwt.search.results.grid.GridRow;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class EagleIDataSetRenderer extends DataSetRenderer {

	public EagleIDataSetRenderer(ResourcesGrid resultsTable, DataSet dataset) {
		this.resultsTable = resultsTable;
		this.dataset = dataset;
	}

	@Override
	public void createInstanceRow(int row, DataSet dataset, SearchResult searchResult) {
		int col = 0;

		// Name cell
		Widget instanceLink = getResourceNameLink( searchResult );
		HTML snippit = (HTML)getSnippit( searchResult );
		Label typeLabel = new Label( searchResult.getType().getLabel() );
		Label rootTypeLabel = getRootTypeLabel( searchResult );
		// Location cell
		Hyperlink labLink = getLabLink( searchResult );
		Label instLabel = new Label( searchResult.getInstitution().getLabel() );

		EagleIGridRow gridRow = new EagleIGridRow();
		gridRow.setResourceNameWidget( instanceLink );
		gridRow.setResourceSnippitWidget( snippit );
		gridRow.setResourceClassWidget( rootTypeLabel );
		gridRow.setResourceTypeWidget( typeLabel );
		gridRow.setResourceInstitutionWidget( instLabel );
		gridRow.setResourceLabWidget( labLink );
		resultsTable.addRow( gridRow );
	}

	private Hyperlink getLabLink(SearchResult searchResult) {
		EIEntity lab = searchResult.getProvider();
		Hyperlink labLink;
		if ( lab != null ) {
			labLink = new Hyperlink( lab.getLabel(), SearchApplicationContext.INSTANCE_PAGE_TOKEN + "uri=" + lab.getURI().toString() );
		} else {
			// empty link to avoid null pointer exceptions
			labLink = new Hyperlink();
		}
		return labLink;
	}

	private Label getRootTypeLabel(SearchResult searchResult) {
		Label rootTypeLabel = null;
		EIEntity rootTypeEntity = resultsTable.currentResults.getMapURIToRootEntity().get( searchResult.getType().getURI() );
		if ( rootTypeEntity != null ) {
			rootTypeLabel = new Label( rootTypeEntity.getLabel() );
		}

		if ( rootTypeLabel != null ) {
			rootTypeLabel.addStyleName( "rootType" );
		}
		return rootTypeLabel;
	}

}