package org.eaglei.ui.gwt.suggest.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.lexical.EntityMatch;
import org.eaglei.lexical.EntityMatchRequest;
import org.eaglei.lexical.SuggestionProvider;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AutoSuggestConstants;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * Dataset-based auto-suggest servlet implementation.
 * 
 * @author tbashor
 */
public class DataSuggestServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;
	
    protected static final Log logger = LogFactory.getLog(DataSuggestServlet.class);
    protected static final boolean DEBUG = logger.isDebugEnabled(); 

	/*
	 * Suggestion provider.
	 */
    private SuggestionProvider provider;

    /**
     * Default constructor. 
     */
    public DataSuggestServlet() {
        // TODO Auto-generated constructor stub
    }
    
    @Override
    public void init() {
        WebApplicationContext ctx = 
            WebApplicationContextUtils.getWebApplicationContext(getServletContext());
        provider = (SuggestionProvider) ctx.getBean("autoSuggestProvider");
    }
    
	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	    doPost(request, response);
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		EntityMatchRequest entityRequest = null;
		try {
	        String id = request.getParameter("id");
	        String asyncCallback = request.getParameter("callback");
	        
	        entityRequest = createRequest(request);
	        entityRequest.setMaxMatches(10);
	        
	        //String institution = request.getParameter(AutoSuggestConstants.RESOURCE_PROVIDER_INSTITUTION_PARAM);
	        List<EntityMatch> suggestions = provider.suggest(entityRequest);
	        
	        StringBuilder sb = new StringBuilder();
	        sb.append(asyncCallback);
	        sb.append("({");  // function wrap start
	        writeJsonNameValueString(sb, "id", id);
	        sb.append(',');
	        /*  Commenting out return of the user query input.
	         *  It is only used for debugging, and putting user input
	         *  into json is a potential security risk.
	        writeJsonNameValueString(sb, "q", q);
	        sb.append(',');
	        */
	        sb.append("suggestions");
	        sb.append(":[");
	        if (suggestions != null && suggestions.size() > 0) {
	            int i=0;
	            while (true) {
	                EntityMatch suggestion = suggestions.get(i++);
	                sb.append("\"");
	                sb.append(suggestion.getHighlight());
	                sb.append("\"");
	                sb.append(',');
	                writeJsonValueString(sb, suggestion.getMatchLabel());
	                sb.append(',');
	                writeJsonValueString(sb, suggestion.getEntity().getURI().toString());
	                sb.append(',');
	                writeJsonValueString(sb, suggestion.getRootTypeLabel() != null ? suggestion.getRootTypeLabel() : "<null>");
	                if (i == suggestions.size()) {
	                    break;
	                } else {
	                    sb.append(',');
	                }
	            }
	        }
	        sb.append("]");
	        sb.append("})");  // function wrap end
	        String output = sb.toString();
	
	        response.setContentType("text/javascript");
	        response.addHeader("Pragma", "no-cache");
	        response.setStatus(200);
	        
	        PrintWriter out = response.getWriter();
	
	        out.println(output);
		} catch (Throwable t) {
			logger.error("Unexpected error getting suggestions: request: " + 
					entityRequest != null ? entityRequest.toString() : "null", t);
			throw new ServletException(t);
		}
	}
	
    private static void writeJsonNameValueString(StringBuilder sb, String name, String value) {
        sb.append(name);
        sb.append(":");
        writeJsonValueString(sb, value);
    }

    private static void writeJsonValueString(StringBuilder sb, String value) {
        sb.append("\"");
        sb.append(value);
        sb.append("\"");
    }
    
    private static EntityMatchRequest createRequest(HttpServletRequest httpRequest) {
        String q = httpRequest.getParameter(AutoSuggestConstants.QUERY_PARAM);
        // Needed to bracket the query with some delimiter, otherwise trailing whitespace is lost.
        // Strip the brackets here, we don't need them for the json response.
        q = q.substring(1, q.length() - 1);
        // getParameter does the decoding for us
        //System.out.println("encoded: "+q);
        //q = URLDecoder.decode(q, "UTF-8");
        //System.out.println("decoded: "+q);
        String classid = httpRequest.getParameter(AutoSuggestConstants.BINDING_TYPE_PARAM);
        EntityMatchRequest searchRequest = null;
        if (classid == null) {
            searchRequest = new EntityMatchRequest(q);
        } else {                
            String decodedClassId = URLDecoder.decode(classid);
            searchRequest = new EntityMatchRequest(q, EIURI.create(decodedClassId));
        }
        String property = httpRequest.getParameter(AutoSuggestConstants.PROPERTY_PARAM);
        if (property != null) {
        	searchRequest.setProperty(property);
        }
    	return searchRequest;
    }

}
